   /* Y=log(mean(X)/Geometric), ACCURE= error; */

double  RHOHAT(Y,ACCURE)
double  Y, ACCURE;
{
    int    i,  ICODE=0;
    void   POLG();
    double RH,R1,PSI;
    double *POL;

    POL=dvector(1,1);
     
    RH=0.25*(1.0+sqrt(1.0+4.0*Y/3.0))/Y;
             
    for (i=1;i<=100;i++){
         R1=RH;
         POLG(R1,&PSI,POL,0,ICODE);
         RH=R1*(log(R1)-PSI)/Y;
         if ( fabs(R1-RH) < ACCURE )  break;
         } 
 free_dvector(POL,1,1);
 return (RH);
}/*//////////////////*/

/*////////////////////////////////////////////////////////////////////
  This progrmm compute psi(x) and up to the Nth derivatives of psi(x)
 Input Para:   0.0 < X <= 4000.0, 
               N=Higest degree of derivates desired: N > 0

 Output Para:  PSI     ---- Derivative of log-gama(x) evaluated at  X
               POL[N]  ---- 1:N derivatives of PSN(x) evaluated at  X
               ICODE   ---- Completion CODE:
                      ICODE=0 ---- NORMAL RETURN;
                      ICODE=1 ---- IMPROPER INPUT PARAMETER
                                   X IS NOT POSITIVE
                      ICODE=2 ---- IMPROPER INPUT PARAMETER
                                   N OUTSIDE RANGE
 //////////////////////////////////////////////////////////////////*/  

void     POLG(X,PSI,POL,N,ICODE)

double   X, *PSI;
double   POL[];
int      N, ICODE;
{
  int      i, j, k, m;
  int      INDX, IN;
  double   X2,DI,DJ,DUM,DS;
  double   *W, *BER;

  W  =dvector(1,8);
  BER=dvector(1,8);

  BER[1]=0.1666666666666667E0, 
  BER[2]=0.3333333333333335E-1,
  BER[3]=0.2380952380952381E-1,
  BER[4]=0.3333333333333335E-1,
  BER[5]=0.7575757575757580E-1,
  BER[6]=0.2531135531135533E0,
  BER[7]=0.1166666666666666E1,
  BER[8]=0.7092156862745101E1;
   
  /*//////// Check valid input parameter X and N ////////*/ 

  ICODE=0;

  if (X < 0.01 || X > 4000.0) {
      nrerror("X is not positive in routine POLG");  
      ICODE = 1;}
  if (N < 0 || N > 20 ){
      nrerror("N outside range in routine POLG");  
      ICODE = 2;}
  if (ICODE > 0 ) 
      nrerror("Input error in routine POLG"); 
   
  /*//// Increment X to larger X greater than 40.0 /////*/
  
  INDX=0; 
   
  X2 = X; 
  for (i=1;i<=40;i++){
       if ( X2 > 40.0 ) break;
       INDX=INDX+1;
       X2  =X2+1.0;
       }
  IN=8;    
  if ( X2 > 100.0 && X2 <= 200.0 ) IN=6;
  if ( X2 > 200.0 && X2 <= 500.0 ) IN=4;
  if ( X2 > 500.0  )               IN=3;
   
  /*////  0 up to N order derivatives of PSI(x) ////*/

  if ( N > 0 ) {    
       DUM=1.0/X2;
       for (i=1;i<=N;i++){
            DI=i;   
            POL[i]=DUM*(1.0+DI*0.5/X2);
            DUM=-DUM*DI/X2;
            for (j=1;j<=IN;j++) {
                 DJ=j;
                 if ( i == 1 )  W[j]=pow(-1.0,(j+1))*BER[j]/pow(X2,(2*j+1));
                 if ( i >  1 )  W[j]*=(1.0-DI-2.0*DJ)/X2;
                 POL[i]+=W[j];
                 }
            }
       }  
  
  *PSI=log(X2)-0.5/X2; 
  for (i=1;i<=IN;i++){
       DI=i*2;
       DUM=BER[i]/(pow(X2,(i*2))*DI);
      *PSI+=pow(-1.0,i)*DUM; 
       }
  if  ( N > 0 ) {
        for (i=1;i<=N;i++){
             DS=0.0;
             for (j=1;j<=INDX;j++){
                  DJ=INDX-j;
                  DUM=1.0/(X+DJ);
                  DJ=DUM; 
                  for (k=1;k<=i;k++){
                       DI=k;
                       DJ*=DI*DUM;
                       }
                  DS+=DJ;
                  }
             POL[i]+=-pow(-1.0,i)*DS;  
             }
        }       
   for (i=1;i<=INDX;i++){
        DUM=i-1;
       *PSI+=-1.0/(X+DUM);
        }
 free_dvector(BER,1,8);
 free_dvector(W,  1,8);
}/*////////////////////*/
